/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class VWSIMConsoleTreeCellRender
extends JLabel
implements TreeCellRenderer {
    private SystemColor m_selectedBgColor = SystemColor.textHighlight;

    public VWSIMConsoleTreeCellRender() {
        this.setOpaque(true);
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean bSelected, boolean bExpanded, boolean bLeaf, int row, boolean bHasFocus) {
        VWSIMBaseNode bNode = (VWSIMBaseNode)value;
        int type = bNode.getType();
        switch (type) {
            case 16: 
            case 18: {
                String tooltipText = null;
                if (bSelected) {
                    VWSIMFolderNode folderNode = (VWSIMFolderNode)bNode;
                    if (folderNode.m_bFolderOverflow) {
                        this.setIcon(VWSIMFolderNode.nodeIconOpenOverflow16);
                        tooltipText = VWSIMResource.FolderItemOverflow.toString(Integer.toString(folderNode.m_itemCount, folderNode.getFolderFilterLimit()));
                    } else {
                        this.setIcon(VWSIMFolderNode.nodeIconOpen16);
                        tooltipText = VWSIMResource.FolderItemCount.toString(Integer.toString(folderNode.m_itemCount, folderNode.getFolderFilterLimit()));
                    }
                } else {
                    this.setIcon(VWSIMFolderNode.nodeIconClosed16);
                }
                this.setToolTipText(tooltipText);
                break;
            }
            case 17: 
            case 20: 
            case 33: 
            case 34: {
                this.setIcon(bNode.getIcon16());
                break;
            }
        }
        this.setText(bNode.getName());
        if (bSelected) {
            this.setBackground(this.m_selectedBgColor);
            this.setForeground(SystemColor.textHighlightText);
        } else {
            this.setBackground(tree.getBackground());
            this.setForeground(tree.getForeground());
        }
        return this;
    }

    public void setSelectionActive(boolean bActive) {
        this.m_selectedBgColor = bActive ? SystemColor.textHighlight : SystemColor.textInactiveText;
    }
}

